<?php

declare(strict_types = 1);

namespace JuicyCodes\Signer\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Routing\Exceptions\InvalidSignatureException;
use JuicyCodes\Signer\Signer;

class ValidateSignature
{
    public function handle(Request $request, Closure $next): mixed
    {
        if (!app(Signer::class)->hasValidSignature($request)) {
            throw new InvalidSignatureException;
        }

        return $next($request);
    }
}
