<?php

declare(strict_types = 1);

namespace JuicyCodes\Signer;

use Illuminate\Contracts\Foundation\Application;
use Illuminate\Encryption\Encrypter as BaseEncrypter;
use Illuminate\Support\ServiceProvider;

class SignerServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->app->singleton(Signer::class, function (Application $app) {
            $config = $app->make('config')->get('app');
            $secret = app(BaseEncrypter::class)->getKey();

            return new Signer($secret, $config['cipher']);
        });
    }
}
