<?php

namespace JuicyCodes\Updater;

use Illuminate\Support\Facades\Config;
use Illuminate\Support\ServiceProvider;

class UpdateServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        Config::set("backup", setDefaultBackupConfig());
        Config::set("backup.backup.name", "backups");

        $defaultExcludes = Config::get("backup.backup.source.files.exclude");
        Config::set("backup.backup.source.files.exclude", array_merge($defaultExcludes, [base_path('storage')]));

        $default = config("database.connections.mysql");
        Config::set("database.connections.mysql", array_merge($default, [
            'dump_binary_path' => storage_path("app" . DIRECTORY_SEPARATOR . "database"),
            'use_single_transaction',
            'timeout'          => 60 * 5,
            'exclude_tables'   => [],
            'add_extra_option' => '',
        ]));
    }

    public function register(): void
    {
        $this->app->singleton("updater", AppUpdater::class);
    }
}
