<?php


namespace JuicyCodes\Updater\Support;

use Exception;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\File;
use JuicyCodes\Updater\Exceptions\PackageDownloadFailedException;

class UpdatePackage
{
    public string $version;

    public object $properties;

    /**
     * @return string
     */
    public function getVersion(): string
    {
        return $this->version;
    }

    /**
     * @return string
     */
    public function getDownloadLink(): string
    {
        return $this->properties->link;
    }

    /**
     * @return string
     */
    public function generatePackageName(): string
    {
        return sprintf("%s.zip", $this->getVersion());
    }

    /**
     * @return object
     */
    public function getProperties(): object
    {
        return $this->properties;
    }

    /**
     * @return array
     */
    public function toArray(): array
    {
        return (array) $this;
    }

    /**
     * @return string|null
     * @throws PackageDownloadFailedException
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function download(): ?string
    {
        try {
            $client  = new Client();
            $fileDir = storage_path("app" . DIRECTORY_SEPARATOR . "updates");

            if (!File::isDirectory($fileDir)) {
                if (!mkdir($fileDir, 0777, true) && !is_dir($fileDir)) {
                    throw new \RuntimeException(sprintf('Directory "%s" was not created', $fileDir));
                }
            }

            if (is_file($filePath = sprintf("%s/%s", $fileDir, $this->generatePackageName()))) {
                unlink($filePath);
            }

            $client->request("GET", $this->getDownloadLink(), ["sink" => $filePath]);
        } catch (Exception $exception) {
            throw new PackageDownloadFailedException("Unable to download updated packages");
        }

        return $filePath ?? null;
    }
}
