<?php

namespace JuicyCodes\Updater\Support;

use Exception;
use Illuminate\Support\Facades\File;
use JuicyCodes\Updater\Exceptions\CallbackExecutionFailedException;
use JuicyCodes\Updater\Exceptions\UnablePackageExtractException;
use JuicyCodes\Updater\Exceptions\UnableRemoveFilesException;
use ZipArchive;

class SelfUpdater
{
    /**
     * @return bool
     * @throws UnableRemoveFilesException
     */
    public static function remove(): bool
    {
        try {
            $filePath = base_path("remove.txt");

            if (file_exists($filePath)) {
                $file        = file_get_contents($filePath, true);
                $data        = str_replace('"', '', $file);
                $sourcePaths = explode(',', $data);

                foreach ($sourcePaths as $sourcePath) {
                    $path = base_path() . DIRECTORY_SEPARATOR . $sourcePath;

                    if (is_dir($path)) {
                        $remove = File::deleteDirectory($path);
                    }
                    if (file_exists($path) && !is_dir($path)) {
                        $remove = unlink($path);
                    }
                }

                unlink($filePath);
            } else {
                $remove = true;
            }
        } catch (Exception $exception) {
            throw new UnableRemoveFilesException("Unable to remove files & folders");
        }

        return $remove ?? false;
    }

    /**
     * @param string $filePath
     * @return bool
     * @throws UnablePackageExtractException
     */
    public static function extract(string $filePath): bool
    {
        try {
            $extracted = false;
            $zip = new ZipArchive();
            $res = $zip->open($filePath);

            if ($res === true) {
                $zip->extractTo(base_path());
                $zip->close();
                $extracted = true;
            }
        } catch (Exception $e) {
            throw new UnablePackageExtractException("Unable to extract updated downloaded packages");
        }

        return (bool) $extracted;
    }

    /**
     * @return bool
     * @throws CallbackExecutionFailedException
     */
    public static function callback(): bool
    {
        try {
            $filePath = app_path("CallBack.php");

            if (file_exists($filePath)) {
                $classes = get_declared_classes();
                require_once $filePath;
                $diff     = array_diff(get_declared_classes(), $classes);
                $callback = reset($diff);

                if (class_exists($callback)) {
                    $call = new $callback();
                    $execute = method_exists($call, 'execute') ? $call->execute() : false;
                }
            } else {
                $execute = true;
            }
        } catch (Exception $exception) {
            throw new CallbackExecutionFailedException("Failed to execute callback functions");
        }

        return $execute ?? false;
    }
}
