<?php


namespace JuicyCodes\Updater\Backups;


use Exception;
use Spatie\Backup\Events\BackupHasFailed;
use Spatie\Backup\Exceptions\InvalidBackupJob;
use Spatie\Backup\Tasks\Backup\BackupJob;
use Spatie\TemporaryDirectory\TemporaryDirectory;

class Backup extends BackupJob
{
    /**
     * @return string|null
     * @throws Exception
     */
    public function backup(): ?string
    {
        $temporaryDirectoryPath = config('backup.backup.temporary_directory') ?? storage_path('app/backup-temp');

        $this->temporaryDirectory = (new TemporaryDirectory($temporaryDirectoryPath))
            ->name('temp')
            ->force()
            ->create()
            ->empty();

        try {
            if (! count($this->backupDestinations)) {
                throw InvalidBackupJob::noDestinationsSpecified();
            }

            $manifest = $this->createBackupManifest();

            if (! $manifest->count()) {
                throw InvalidBackupJob::noFilesToBeBackedUp();
            }

            $zipFile     = $this->createZipContainingEveryFileInManifest($manifest);
            $destination = $this->backupDestinations->first()->backupName() . '/' . pathinfo($zipFile, PATHINFO_BASENAME);
            $this->copyToBackupDestinations($zipFile);

        } catch (Exception $exception) {

            $this->sendNotification(new BackupHasFailed($exception));

            $this->temporaryDirectory->delete();

            throw $exception;
        }

        $this->temporaryDirectory->delete();

        return $destination ? storage_path("app" . DIRECTORY_SEPARATOR . $destination) : null;
    }
}
