<?php

declare(strict_types=1);

namespace JuicyCodes\Plugin\Support\Traits\Plugin;

use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

trait HasVendors
{
    protected function hasVendors(): self
    {
        $basePath = self::getPluginPath();
        File::requireOnce("{$basePath}/resources/vendor/autoload.php");

        return $this;
    }

    public static function getPluginPath(): string
    {
        $plugin = self::getPluginName();

        return app_path("Plugins/{$plugin}");
    }

    public static function getPluginName(): string
    {
        $prefix = "App\Plugins\\";

        return Str::before(str_replace($prefix, "", static::class), "\\");
    }
}
