<?php

declare(strict_types=1);

namespace JuicyCodes\Plugin\Support;

class RecursiveCollectionMacro
{
    /**
     * @return \Closure
     * @psalm-suppress all
     */
    public function __invoke()
    {
        /**
         * @mixin \Illuminate\Support\Collection
         * @param int $maxDepth
         * @param int $traversed
         * @return mixed
         */
        return function (int $maxDepth = 0, int $traversed = 0) {
            return $this->map(function ($value) use ($maxDepth, $traversed) {
                $traversedEnough = $maxDepth === 0 ? false : $traversed >= $maxDepth;

                if (!$traversedEnough && (is_array($value) || is_object($value))) {
                    return (new static($value))->recursive($maxDepth, ++$traversed);
                }

                return $value;
            });
        };
    }
}
