<?php

declare(strict_types=1);

namespace JuicyCodes\Plugin;

use Illuminate\Contracts\Http\Kernel;
use Illuminate\Foundation\Bootstrap\BootProviders;
use Illuminate\Support\Collection;
use Illuminate\Support\ServiceProvider;
use JuicyCodes\Plugin\Support\PluginMiddleware;
use JuicyCodes\Plugin\Support\RecursiveCollectionMacro;

class PluginServiceProvider extends ServiceProvider
{
    /**
     * @psalm-suppress UndefinedInterfaceMethod
     * @throws \Illuminate\Contracts\Container\BindingResolutionException
     */
    public function boot(): void
    {
        assets()->registerBladeDirective();
        $kernel = $this->app->make(Kernel::class);
        $kernel->pushMiddleware(PluginMiddleware::class);
        $this->app->afterBootstrapping(BootProviders::class, fn() => plugin()->boot());

        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__ . '/../config/assets.php' => config_path('assets.php'),
            ], 'config');
        }
    }

    public function register(): void
    {
        $this->app->singleton("plugin", Plugin::class);
        $this->app->singleton("assets", Assets::class);
        $this->mergeConfigFrom(__DIR__ . '/../config/assets.php', 'assets');

        /** @psalm-suppress PossiblyInvalidFunctionCall */
        Collection::macro('recursive', app(RecursiveCollectionMacro::class)());
    }
}
