<?php

declare(strict_types = 1);

namespace JuicyCodes\Plugin\Support\Traits\Plugin;

use JuicyCodes\Plugin\Interfaces\HasRemoteExtension;

trait PluginDetails
{
    protected string $name;

    protected ?string $cover = null;

    protected string $version = "1.0.0";

    protected string $codename;

    protected ?string $shortName = null;

    protected string $description;

    protected array $actions = [];

    protected string $identifier;

    protected bool $isActive = false;

    protected bool $registered = false;

    public function getDetails(): array
    {
        return [
            "name"        => $this->getName(),
            "cover"       => $this->getCover(),
            "version"     => $this->getVersion(),
            "actions"     => $this->getActions(),
            "shortName"   => $this->getShortName(),
            "description" => $this->getDescription(),

            "isActive"           => $this->isActive(),
            "hasRemoteExtension" => $this->hasRemoteExtension(),
        ];
    }

    public function addAction(string $label, string $icon, string $link): self
    {
        $link = plugin()->route($link);

        $this->actions[] = compact("label", "icon", "link");

        return $this;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getCover(): ?string
    {
        return $this->cover;
    }

    public function setCover(?string $cover): self
    {
        $this->cover = $cover;

        return $this;
    }

    public function getVersion(): string
    {
        return $this->version;
    }

    public function setVersion(string $version): self
    {
        $this->version = $version;

        return $this;
    }

    public function getCodename(): string
    {
        return $this->codename;
    }

    public function setCodename(string $codename): self
    {
        $this->codename = "plugin:{$codename}";

        return $this;
    }

    public function getShortName(): ?string
    {
        return $this->shortName;
    }

    public function setShortName(?string $shortName): self
    {
        $this->shortName = $shortName;

        return $this;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function setDescription(string $description): self
    {
        $this->description = $description;

        return $this;
    }

    private function getActions(): array
    {
        return $this->actions;
    }

    public function getIdentifier(): string
    {
        return $this->identifier;
    }

    public function setIdentifier(string $identifier): void
    {
        $this->identifier = $identifier;
    }

    public function isActive(): bool
    {
        return $this->isActive;
    }

    public function setActive(bool $isActive): void
    {
        $this->isActive = $isActive;
    }

    public function isRegistered(): bool
    {
        return $this->registered;
    }

    public function setRegistered(bool $registered): self
    {
        $this->registered = $registered;

        return $this;
    }

    public function hasRemoteExtension(): bool
    {
        return $this instanceof HasRemoteExtension;
    }
}
