<?php

declare(strict_types = 1);

namespace JuicyCodes\Plugin\Contracts;

use JuicyCodes\Core\App;
use JuicyCodes\Core\License;
use JuicyCodes\Plugin\Support\Traits\Plugin\HasVendors;
use JuicyCodes\Plugin\Support\Traits\Plugin\PluginDetails;

abstract class PluginCore
{
    use HasVendors;
    use PluginDetails;

    abstract public function register(): void;

    abstract public function boot(): void;

    public function onActivate(): void
    {
    }

    public function onDeactivate(): void
    {
    }

    final public function registerPlugin(string $identifier): void
    {
        if (!$this->isRegistered()) {
            $this->register();
            $this->setRegistered(true);
            $this->setIdentifier($identifier);
            $this->setActive(plugin()->isPluginActive($identifier));

            App::register($this->getVersion(), $this->getCodename());
        }
    }

    final public function license(): License
    {
        return App::plugin($this->getCodename())->license();
    }

    final public function verifyLicense(): void
    {
        $this->license()->forgetCache();
        $this->license()->verify(true);
    }
}
