<?php

declare(strict_types=1);

namespace JuicyCodes\Plugin\Support\Traits;

use JuicyCodes\Plugin\Contracts\PluginMigration;
use JuicyCodes\Plugin\Exceptions\PluginNotFoundException;
use JuicyCodes\Plugin\Support\Migrator;

trait RunMigrations
{
    /**
     * @param string $plugin
     * @param string $method
     * @throws PluginNotFoundException
     * @throws \Throwable
     */
    public function runMigrations(string $plugin, string $method = "up"): void
    {
        $plugins = $this->foundPlugins();
        if (!isset($plugins[$plugin])) {
            PluginNotFoundException::throw($plugin);
        }

        $plugin  = $plugins[$plugin];
        $classes = collect($plugin["classes"]);

        $classes->where("type", "migration")->pluck("name")
            ->map(fn(string $class) => new $class())
            ->each(fn(PluginMigration $migration) => Migrator::runMigration($migration, $method));
    }
}
