<?php

declare(strict_types = 1);

namespace JuicyCodes\Plugin\Support;

use Closure;
use Illuminate\Http\Request;

class PluginMiddleware
{
    public function handle(Request $request, Closure $next): mixed
    {
        plugin()->executeAction("plugin.middleware.before", $request, $next);

        $response = $next($request);

        plugin()->executeAction("plugin.middleware.after", $response);

        return $response;
    }
}
