<?php

declare(strict_types=1);

namespace JuicyCodes\Plugin\Contracts;

abstract class PluginMigration
{
    public const UP = "up";
    public const DOWN = "down";

    /**
     * The name of the database connection to use.
     *
     * @var string|null
     */
    protected ?string $connection;

    /**
     * Enables, if supported, wrapping the migration within a transaction.
     *
     * @var bool
     */
    public bool $withinTransaction = true;

    /**
     * Run the migrations.
     *
     * @return void
     */
    abstract public function up(): void;

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    abstract public function down(): void;

    /**
     * Whether to run/reverse the migrations.
     *
     * @param string $type
     * @return bool
     */
    abstract public function shouldMigrate(string $type): bool;

    /**
     * @return string[]
     */
    public function seeders(): array
    {
        return [];
    }

    /**
     * Get the migration connection name.
     *
     * @return string|null
     */
    public function getConnection(): ?string
    {
        return $this->connection ?? null;
    }
}
