<?php

declare(strict_types = 1);

namespace JuicyCodes\Plugin\Support;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

class PluginMiddleware
{
    public function handle(Request $request, Closure $next): mixed
    {
        plugin()->executeAction("plugin.middleware.before", $request, $next);
        $this->registerActionForCurrentRoute($request, "before", $request, $next);

        $response = $next($request);

        plugin()->executeAction("plugin.middleware.after", $response);
        $this->registerActionForCurrentRoute($request, "after", $response);

        return $response;
    }

    /**
     * @psalm-suppress RedundantCondition
     */
    private function registerActionForCurrentRoute(Request $request, string $position, mixed &...$parameters): void
    {
        if (($route = $this->getCurrentRouteName($request)) && $route !== null) {
            plugin()->executeAction("{$route}::{$position}", ...$parameters);
        }
    }

    private function getCurrentRouteName(Request $request): ?string
    {
        try {
            return Route::getRoutes()->match($request)->getName();
        } catch (\Throwable) {
        }

        return null;
    }
}
