<?php

declare(strict_types = 1);

namespace JuicyCodes\Plugin\Support\Traits;

use Illuminate\Support\Collection;
use JuicyCodes\Plugin\Contracts\PluginNav;

trait RegisterNavigations
{
    public function registerMenu(string $id): void
    {
        $plugins = $this->foundPlugins();
        foreach ($plugins as $name => $plugin) {
            $instance = $this->getPluginCore(plugin: $name);

            if ($instance->isActive() && $instance->license()->isValid()) {
                $classes = $this->getNavClasses($id, $plugin->get("classes"));
                $classes->each(fn(PluginNav $instance) => $instance->registerMenu());
            }
        }
    }

    public function registerBreadcrumbs(string $id): void
    {
        $plugins = $this->foundPlugins();
        foreach ($plugins as $name => $plugin) {
            $instance = $this->getPluginCore(plugin: $name);

            if ($instance->isActive() && $instance->license()->isValid()) {
                $classes = $this->getNavClasses($id, $plugin["classes"]);
                $classes->each(fn(PluginNav $instance) => $instance->registerBreadcrumbs());
            }
        }
    }

    protected function getNavClasses(string $id, Collection $classes): Collection
    {
        return $classes
            ->where("type", "navigation")->pluck("name")
            ->map(fn(string $class): PluginNav => $this->instance($class))
            ->filter(fn(PluginNav $instance) => $id === $instance->navigationPosition());
    }
}
