<?php

namespace JuicyCodes\Generator\Menu;

use Illuminate\Support\Str;

/**
 * Class Icon
 *
 * @package JuicyCodes\Generator\Menu
 */
class Icon implements \Stringable
{
    /**
     * @var string
     */
    private string $icon;

    /**
     * Icon constructor.
     *
     * @param string $icon
     */
    public function __construct(string $icon)
    {
        $this->icon = $icon;
    }

    /**
     * Check if the icon is an SVG?
     *
     * @return bool
     */
    public function isSvg(): bool
    {
        return Str::startsWith($this->icon, "svg::");
    }

    /**
     * @return string
     */
    public function __toString()
    {
        return Str::replaceFirst("svg::", "", $this->icon);
    }
}
