<?php

namespace JuicyCodes\Generator\Breadcrumbs;

use Closure;

/**
 * Class Trail
 *
 * @date 12-08-2020
 * @package JuicyCodes\Generator\Breadcrumbs
 */
class Trail
{
    /**
     * @var string
     */
    private string $label;

    /**
     * @var Closure
     */
    private Closure $callback;

    /**
     * @var string
     */
    private string  $identifier;

    /**
     * @var string|null
     */
    private ?string  $parent;

    /**
     * @var array
     */
    private array $params = [];

    /**
     * @var Breadcrumbs
     */
    private Breadcrumbs $breadcrumbs;

    /**
     * Trail constructor.
     *
     * @param string      $label
     * @param Closure     $callback
     * @param string      $identifier
     * @param Breadcrumbs $breadcrumbs
     * @param string|null $parent
     */
    public function __construct(string $label, Closure $callback, string $identifier, Breadcrumbs $breadcrumbs, string $parent = null)
    {
        $this->label       = $label;
        $this->parent      = $parent;
        $this->callback    = $callback;
        $this->identifier  = $identifier;
        $this->breadcrumbs = $breadcrumbs;
    }

    /**
     * Proxy a scope call onto the breadcrumb builder.
     *
     * @param string      $label
     * @param Closure     $callback
     * @param string|null $identifier
     * @return void
     * @throws \Throwable
     */
    public function for(string $label, Closure $callback, string $identifier = null): void
    {
        $this->breadcrumbs->for($label, $callback, $identifier, $this->identifier);
    }

    /**
     * @return string
     */
    public function getLabel(): string
    {
        return $this->label;
    }

    /**
     * @return string|null
     */
    public function getLink(): ?string
    {
        return call_user_func($this->callback, ...$this->params);
    }

    /**
     * @return string|null
     */
    public function getParent(): ?string
    {
        return $this->parent;
    }

    /**
     * @return string
     */
    public function getIdentifier(): string
    {
        return $this->identifier;
    }

    /**
     * @return bool
     */
    public function hasParent(): bool
    {
        return !empty($this->parent);
    }

    /**
     * @param array $params
     */
    public function setParams(array $params): void
    {
        $this->params = $params;
    }
}
