<?php

namespace JuicyCodes\Generator\Menu\Parts;

class Label implements \Stringable
{
    /**
     * @var string
     */
    private string $label;

    /**
     * Icon constructor.
     *
     * @param string $label
     */
    public function __construct(string $label)
    {
        $this->label = $label;
    }

    /**
     * @return string
     */
    public function value()
    {
        return $this->label;
    }

    /**
     * @return string|void
     */
    public function __toString()
    {
        if (is_numeric($this->label) && $this->label >= 100) {
            return "99+";
        }

        return $this->label;
    }
}
