<?php

namespace JuicyCodes\Logger;

use Illuminate\Support\Facades\Date;
use Illuminate\Support\ServiceProvider;
use JuicyCodes\Logger\Commands\CleanLogsCommand;

class PackageServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     */
    public function boot(): void
    {
        if ($this->app->runningInConsole()) {
            $this->commands([CleanLogsCommand::class]);

            $timestamp  = Date::now()->format("Y_m_d_His");
            $sourcePath = __DIR__ . '/../migrations/create_logs_table.php.stub';
            $this->publishes([$sourcePath => database_path("/migrations/{$timestamp}_create_logs_table.php")], 'migrations');
        }
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register(): void
    {
        //
    }
}
