<?php

namespace JuicyCodes\Logger\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class Log extends Model
{
    public const UPDATED_AT = null;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var string[]|bool
     */
    protected $guarded = [];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        "context" => "collection",
    ];

    public function subject(): MorphTo
    {
        return $this->morphTo();
    }

    public function writer(): MorphTo
    {
        return $this->morphTo();
    }

    public function scopeWrittenBy(Builder $query, Model $writer): Builder
    {
        return $query
            ->where('writer_type', $writer->getMorphClass())
            ->where('writer_id', $writer->getKey());
    }

    public function scopeForSubject(Builder $query, Model $subject): Builder
    {
        return $query
            ->where('subject_type', $subject->getMorphClass())
            ->where('subject_id', $subject->getKey());
    }
}
