<?php

namespace JuicyCodes\Logger\Commands;

use Illuminate\Console\Command;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Carbon;
use JuicyCodes\Logger\Models\Log;

class CleanLogsCommand extends Command
{
    protected $signature = 'logs:clean {--type=} {--level=} {--days=}';

    public function handle(): void
    {
        $this->comment('Cleaning logs...');

        $type    = $this->option('type');
        $level   = $this->option('level');
        $maxDays = (int) ($this->option('days') ?? 15);

        $cleanBefore   = Carbon::now()->subDays($maxDays);
        $amountDeleted = Log::where('created_at', '<', $cleanBefore)
            ->when($type !== null, fn (Builder $query) => $query->where("type", $type))
            ->when($level !== null, fn (Builder $query) => $query->where("level", $level))
            ->delete();

        $this->info("Deleted {$amountDeleted} record(s) from the logs.");

        $this->comment('All done!');
    }
}
