<?php

namespace JuicyCodes\Logger\Traits;

use Illuminate\Database\Eloquent\Relations\MorphMany;
use JuicyCodes\Logger\Logger;
use JuicyCodes\Logger\Models\Log;

trait WriteLogs
{
    public function log()
    {
        return app(Logger::class)->writtenFor($this);
    }

    public function logs(): MorphMany
    {
        return $this->morphMany(Log::class, 'subject');
    }

    public function writtenLogs(): MorphMany
    {
        return $this->morphMany(Log::class, 'writer');
    }
}
