<?php

namespace JuicyCodes\Logger\Support;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Str;
use JuicyCodes\Logger\Logger;
use JuicyCodes\Logger\Models\Log;

trait RecordLogs
{
    public Logger $loggerInstance;

    /**
     * @param string|null $type
     * @param string|null $message
     * @param array|null  $context
     * @return Log|Logger
     */
    public function log(string $type = null, string $message = null, array $context = [])
    {
        if ($type === null) {
            return $this->loggerInstance();
        }

        return $this->loggerInstance()->log(
            $type,
            $message,
            $context
        );
    }

    public function logs(): HasMany
    {
        $model = new Log();
        $model->setTable($this->getLogsTable());

        return new HasMany(
            $model->newQuery(),
            $this,
            $this->getForeignKey(),
            $this->getKeyName()
        );
    }

    protected function loggerInstance(): Logger
    {
        return $this->loggerInstance ??= new Logger($this);
    }

    protected function getLogsTable(): string
    {
        return Str::singular($this->getTable()) . '_logs';
    }
}
