<?php

namespace JuicyCodes\Logger;

use Illuminate\Support\ServiceProvider;
use JuicyCodes\Logger\Commands\MigrationPublishCommand;

class PackageServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     */
    public function boot(): void
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                MigrationPublishCommand::class,
            ]);
        }
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register(): void
    {
        //
    }
}
