<?php

namespace JuicyCodes\Logger;

use Illuminate\Database\Eloquent\Model;
use JuicyCodes\Logger\Models\Log;
use JuicyCodes\Logger\Support\RecordLogs;

class Logger
{
    public const INFO = "info";
    public const ERROR = "error";
    public const SUCCESS = "success";

    /**
     * @var Model|RecordLogs
     */
    protected Model $model;

    public function __construct(Model $model)
    {
        $this->model = $model;
    }

    public function log(string $type, string $message, array $context = []): Log
    {
        return $this->model->logs()->create(compact(
            "type",
            "message",
            "context"
        ));
    }

    public function info(string $message, array $context = []): void
    {
        $this->log(self::INFO, $message, $context);
    }

    public function error(string $message, array $context = []): void
    {
        $this->log(self::ERROR, $message, $context);
    }

    public function success(string $message, array $context = []): void
    {
        $this->log(self::SUCCESS, $message, $context);
    }
}
