<?php

namespace JuicyCodes\Logger\Commands;

use Illuminate\Database\Console\Migrations\BaseCommand;
use Illuminate\Database\Migrations\MigrationCreator;
use Illuminate\Support\Composer;
use Illuminate\Support\Str;

class MigrationPublishCommand extends BaseCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'logger:publish {table}';

    /**
     * The Composer instance.
     *
     * @var \Illuminate\Support\Composer
     */
    protected Composer $composer;

    /**
     * Create a new migration install command instance.
     *
     * @param \Illuminate\Support\Composer $composer
     * @return void
     */
    public function __construct(Composer $composer)
    {
        parent::__construct();
        $this->composer = $composer;
    }

    /**
     * Execute the console command.
     *
     * @return void
     * @throws \Exception
     */
    public function handle(): void
    {
        $stubPath    = __DIR__ . "/../../stubs/log";
        $parentTable = Str::singular($this->argument('table'));

        $migrator  = new MigrationCreator(app("files"), $stubPath);
        $migration = $migrator->create("create_{$parentTable}_logs_table", database_path("migrations"), $parentTable, true);

        $this->composer->dumpAutoloads();
        $migration = pathinfo($migration, PATHINFO_FILENAME);
        $this->line("<info>Created Migration:</info> {$migration}");
    }
}
