<?php

namespace JuicyCodes\Logger\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Support\Str;

/**
 * @method writtenBy(Builder $query, Model $writer): Builder
 * @method forSubject(Builder $query, Model $subject): Builder
 * @method whereUuid(Builder $query, array|string $uuid): Builder
 */
class Log extends Model
{
    public const UPDATED_AT = null;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var string[]|bool
     */
    protected $guarded = [];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        "context" => "collection",
    ];

    public static function booted()
    {
        static::creating(function (self $model) {
            $model->setAttribute("uuid", Str::uuid()->toString());
        });
    }

    public function subject(): MorphTo
    {
        return $this->morphTo();
    }

    public function writer(): MorphTo
    {
        return $this->morphTo();
    }

    public function scopeWrittenBy(Builder $query, Model $writer): Builder
    {
        return $query
            ->where('writer_type', $writer->getMorphClass())
            ->where('writer_id', $writer->getKey());
    }

    public function scopeForSubject(Builder $query, Model $subject): Builder
    {
        return $query
            ->where('subject_type', $subject->getMorphClass())
            ->where('subject_id', $subject->getKey());
    }

    public function scopeWhereUuid(Builder $query, array|string $uuid): Builder
    {
        return (!is_array($uuid)
            ? $query->where("uuid", $uuid)
            : $query->whereIn("uuid", $uuid)
        );
    }
}
