<?php

namespace JuicyCodes\KV\Support;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Str;
use JuicyCodes\KV\Repositories\MetaRepository;

trait Metable
{
    private ?MetaRepository $metaRepoInstance = null;

    /**
     * @param array|string|null $key
     * @param mixed             $default
     * @return void|mixed|MetaRepository
     */
    public function meta($key = null, $default = null)
    {
        $instance = $this->metaRepoInstance();

        if (empty($key)) {
            return $instance;
        }

        if (is_array($key)) {
            $instance->set($key);

            return;
        }

        return $instance->get($key, $default);
    }

    public function metas(): HasMany
    {
        return $this->metaRepoInstance()->getQuery();
    }

    protected function metaRepoInstance(): MetaRepository
    {
        return $this->metaRepoInstance
            ??= new MetaRepository($this, $this->getMetaTable());
    }

    /**
     * Return the meta table name.
     *
     * @return string
     */
    protected function getMetaTable(): string
    {
        return Str::singular($this->getTable()) . '_meta';
    }
}
