<?php

use JuicyCodes\KV\Repositories\SettingsRepository;

if (!function_exists('setting')) {
    /**
     * @param array|string|null $key
     * @param mixed             $default
     * @return void|mixed|\JuicyCodes\KV\Repositories\SettingsRepository
     */
    function setting($key = null, $default = null)
    {
        /** @var \JuicyCodes\KV\Repositories\SettingsRepository $instance */
        $instance = app(SettingsRepository::class);

        if (empty($key)) {
            return $instance;
        }

        if (is_array($key)) {
            $instance->set($key);

            return;
        }

        return $instance->get($key, $default);
    }
}
