<?php

namespace JuicyCodes\KV\Repositories;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Traits\ForwardsCalls;
use JuicyCodes\KV\Models\Meta;

class MetaRepository extends KeyValueRepository
{
    use ForwardsCalls;

    protected Model $model;

    protected string $metaTable;

    public function __construct(Model $model, string $metaTable, bool $cacheRecords)
    {
        $this->setModel($model);
        $this->setMetaTable($metaTable);
        $this->shouldCacheRecords($cacheRecords);
    }

    public function getQuery(): HasMany
    {
        $metaModel = new Meta();
        $metaModel->setTable($this->getMetaTable());

        return (new HasMany(
            $metaModel->newQuery(),
            $this->getModel(),
            $this->getModel()->getForeignKey(),
            $this->getModel()->getKeyName()
        ));
    }

    protected function getCacheKey(): string
    {
        if (empty($this->model->uuid)) {
            throw new \RuntimeException("UUID attribute is required when caching meta data.");
        }

        return "kv::meta_{$this->model->uuid}";
    }

    public function getModel(): Model
    {
        return $this->model;
    }

    public function setModel(Model $model): void
    {
        $this->model = $model;
    }

    public function getMetaTable(): string
    {
        return $this->metaTable;
    }

    public function setMetaTable(string $metaTable): void
    {
        $this->metaTable = $metaTable;
    }

    public function __call(string $method, array $parameters): mixed
    {
        return $this->forwardCallTo($this->getQuery()->newQuery(), $method, $parameters);
    }
}
