<?php

namespace JuicyCodes\KV;

use Illuminate\Support\ServiceProvider;
use JuicyCodes\KV\Console\Commands\MigrationPublishCommand;
use JuicyCodes\KV\Repositories\SettingsRepository;

class PackageServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     */
    public function boot(): void
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                MigrationPublishCommand::class,
            ]);
        }
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register(): void
    {
        $this->app->singleton(SettingsRepository::class);
    }
}
