<?php

use JuicyCodes\KV\Repositories\SettingsRepository;

if (!function_exists('setting')) {
    /**
     * @param array|string|null $key
     * @param mixed             $default
     * @return mixed|bool|\JuicyCodes\KV\Repositories\SettingsRepository
     */
    function setting(array|string|null $key = null, mixed $default = null): mixed
    {
        /** @var \JuicyCodes\KV\Repositories\SettingsRepository $instance */
        $instance = app(SettingsRepository::class);

        if (empty($key)) {
            return $instance;
        }

        if (is_array($key)) {
            return $instance->set($key);
        }

        return $instance->get($key, $default);
    }
}
