<?php

namespace JuicyCodes\KV\Console\Commands;

use Illuminate\Database\Console\Migrations\BaseCommand;
use Illuminate\Database\Migrations\MigrationCreator;
use Illuminate\Support\Composer;
use Illuminate\Support\Str;

class MigrationPublishCommand extends BaseCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'kv:publish {table}';

    /**
     * The Composer instance.
     *
     * @var \Illuminate\Support\Composer
     */
    protected Composer $composer;

    /**
     * Create a new migration install command instance.
     *
     * @param \Illuminate\Support\Composer $composer
     * @return void
     */
    public function __construct(Composer $composer)
    {
        parent::__construct();
        $this->composer = $composer;
    }

    /**
     * Execute the console command.
     *
     * @return void
     * @throws \Exception
     */
    public function handle(): void
    {
        $table = $this->argument('table');

        if ($table === "settings") {
            $stubDir       = "settings";
            $migrationName = "create_{$table}_table";
        } else {
            $table = Str::singular($table);

            $stubDir       = "meta";
            $migrationName = "create_{$table}_meta_table";
        }

        $stubPath  = __DIR__ . "/../../../stubs/{$stubDir}";
        $migrator  = new MigrationCreator(app("files"), $stubPath);
        $migration = $migrator->create($migrationName, database_path("migrations"), $table, true);

        $this->composer->dumpAutoloads();
        $migration = pathinfo($migration, PATHINFO_FILENAME);
        $this->line("<info>Created Migration:</info> {$migration}");
    }
}
