<?php

namespace JuicyCodes\KV\Repositories;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Traits\ForwardsCalls;
use JuicyCodes\KV\Models\Meta;

class MetaRepository extends KeyValueRepository
{
    use ForwardsCalls;

    protected Model $model;

    protected string $metaTable;

    public function __construct(Model $model, string $metaTable, bool $cacheRecords)
    {
        $this->setModel($model);
        $this->setMetaTable($metaTable);
        $this->shouldCacheRecords($cacheRecords);

        if (empty($model->uuid)) {
            throw new \RuntimeException("UUID attribute is required when using metable trait.");
        }
    }

    public function getQuery(): HasMany
    {
        $metaModel = new Meta();
        $metaModel->setTable($this->getMetaTable());

        return (new HasMany(
            $metaModel->newQuery(),
            $this->getModel(),
            $this->getModel()->getForeignKey(),
            $this->getModel()->getKeyName()
        ));
    }

    protected function getCacheKey(): string
    {
        return "kv::meta_{$this->model->uuid}";
    }

    public function getModel(): Model
    {
        return $this->model;
    }

    public function setModel(Model $model): void
    {
        $this->model = $model;
    }

    public function getMetaTable(): string
    {
        return $this->metaTable;
    }

    public function setMetaTable(string $metaTable): void
    {
        $this->metaTable = $metaTable;
    }

    /**
     * Handle dynamic method calls into the model.
     *
     * @param string $method
     * @param array  $parameters
     * @return mixed
     */
    public function __call(string $method, array $parameters)
    {
        return $this->forwardCallTo($this->getQuery()->newQuery(), $method, $parameters);
    }
}
