<?php

namespace JuicyCodes\GeoIp\Providers;

use JuicyCodes\GeoIp\Support\GeoData;

class IPNFProvider extends AbstractProvider
{
    /**
     * @param string $ip
     * @return GeoData
     * @throws \Illuminate\Http\Client\RequestException
     * @throws \JuicyCodes\GeoIp\Exceptions\GeoIpException
     */
    public function locate(string $ip): GeoData
    {
        $response = $this->http()
            ->get("https://ip.nf/{$ip}.json")->throw();

        return $this->hydrate($ip, $response->json("ip.country_code"));
    }
}
