<?php

namespace JuicyCodes\GeoIp\Providers;

use JuicyCodes\GeoIp\Support\GeoData;

class GeoJsProvider extends AbstractProvider
{
    /**
     * @param string $ip
     * @return \JuicyCodes\GeoIp\Support\GeoData
     * @throws \Illuminate\Http\Client\RequestException
     * @throws \JuicyCodes\GeoIp\Exceptions\GeoIpException
     */
    public function locate(string $ip): GeoData
    {
        $response = $this->http()
            ->get("https://get.geojs.io/v1/ip/country/{$ip}.json")->throw();

        return $this->hydrate($ip, $response->json("country"));
    }
}
