<?php

namespace JuicyCodes\GeoIp\Providers;

use Illuminate\Support\Arr;
use JuicyCodes\GeoIp\Exceptions\GeoIpException;
use JuicyCodes\GeoIp\Support\GeoData;
use League\ISO3166\ISO3166;

class GeoIpModuleProvider extends AbstractProvider
{
    /**
     * @param string $ip
     * @return GeoData
     * @throws GeoIpException
     */
    public function locate(string $ip): GeoData
    {
        $header = $this->config("header");
        if (!array_key_exists($header, $_SERVER)) {
            throw new GeoIpException("The provided GeoIP module key is not present in the env variables.");
        }

        return $this->hydrate($ip, $_SERVER[$header]);
    }

    /**
     * @param string $code
     * @return string
     */
    private function getCountryName(string $code): string
    {
        $iso = new ISO3166();

        return Arr::get($iso->alpha2($code), "name");
    }
}
