<?php

namespace JuicyCodes\GeoIp;

use Illuminate\Support\ServiceProvider;

class GeoIpServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__ . '/../config/geoip.php' => config_path('geoip.php'),
            ], 'config');
        }

        $this->mergeConfigFrom(__DIR__ . '/../config/geoip.php', 'geoip');
    }

    public function register(): void
    {
        $this->app->singleton("geoip", GeoIp::class);
    }
}
