<?php

namespace JuicyCodes\GeoIp\Providers;

use Illuminate\Http\Client\PendingRequest;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Http;
use JuicyCodes\GeoIp\Support\GeoData;

abstract class AbstractProvider
{
    protected array $config;

    /**
     * AbstractProvider constructor.
     *
     * @param array $config
     */
    public function __construct(array $config)
    {
        $this->config = $config;
    }

    abstract public function locate(string $ip): GeoData;

    /**
     * @param string      $ip
     * @param string|null $country
     * @return \JuicyCodes\GeoIp\Support\GeoData
     * @throws \JuicyCodes\GeoIp\Exceptions\GeoIpException
     */
    protected function hydrate(string $ip, ?string $country): GeoData
    {
        return new GeoData($ip, $country, static::class);
    }

    /**
     * @param array $options
     * @return PendingRequest
     */
    protected function http(array $options = []): PendingRequest
    {
        return Http::withOptions($options)
            ->timeout($this->config("geoip.timeout", 5));
    }

    /**
     * Get configuration value.
     *
     * @param string $key
     * @param mixed  $default
     * @return mixed
     */
    protected function config(string $key, $default = null)
    {
        return Arr::get($this->config, $key, $default);
    }
}
