<?php

return [
    /*
     * Configure whether the geolocation data should be cached or not.
     */
    "cache"     => true,

    /*
     * Specify the timeout (in seconds) for an API request.
     */
    "timeout"   => 10,

    /**
     * Here you may specify the primary & fallback geolocation data providers.
     * Set fallback to null to disable fallback system.
     */
    "provider"  => [
        "primary"  => "geojs",
        "fallback" => null,
    ],

    /*
     * Here you may configure as many geolocation data providers as you wish.
     */
    "providers" => [
        "ipnf"         => [
            "class" => \JuicyCodes\GeoIp\Providers\IPNFProvider::class
        ],
        "ip-api"       => [
            "key"   => null,
            "class" => \JuicyCodes\GeoIp\Providers\IpApiProvider::class,
        ],
        "geojs"        => [
            "class" => \JuicyCodes\GeoIp\Providers\GeoJsProvider::class
        ],
        "maxmind"      => [
            "link"    => null,
            "license" => null,
            "class"   => \JuicyCodes\GeoIp\Providers\MaxMindProvider::class
        ],
        "freegeoip"    => [
            "class" => \JuicyCodes\GeoIp\Providers\FreeGeoIpProvider::class
        ],
        "geoip-module" => [
            "header" => "GEOIP_COUNTRY_CODE",
            "class"  => \JuicyCodes\GeoIp\Providers\GeoIpModuleProvider::class
        ]
    ]
];
