<?php

namespace JuicyCodes\GeoIp\Providers;

use JuicyCodes\GeoIp\Exceptions\GeoIpException;
use JuicyCodes\GeoIp\Support\GeoData;

class IpApiProvider extends AbstractProvider
{
    /**
     * @param string $ip
     * @return \JuicyCodes\GeoIp\Support\GeoData
     * @throws \Illuminate\Http\Client\RequestException|GeoIpException
     */
    public function locate(string $ip): GeoData
    {
        $baseUri  = $this->getBaseUri();
        $response = $this->http()
            ->get("{$baseUri}/json/{$ip}", $this->getRequestQuery())->throw();

        // Check if request was successful
        if ($response->json("status") !== "success") {
            throw new GeoIpException("[IP-INFO:ERROR] Failed to get geo data ({$response->json("message")}).");
        }

        return $this->hydrate($ip, $response->json("countryCode"));
    }

    /**
     * @return string
     */
    private function getBaseUri(): string
    {
        return empty($this->config("key"))
            ? "http://ip-api.com"
            : "https://pro.ip-api.com";
    }

    /**
     * @return array
     */
    private function getRequestQuery(): array
    {
        return array_filter([
            "key"    => $this->config("key"),
            "fields" => "status,message,countryCode,query",
        ]);
    }
}
