<?php

declare(strict_types = 1);

namespace JuicyCodes\Core;

use Illuminate\Cache\RateLimiter;
use Illuminate\Console\Command;

class CheckLicenseCommand extends Command
{
    protected $signature = "app:check-license";

    public function handle(RateLimiter $limiter): void
    {
        if ($limiter->tooManyAttempts($this->signature, 1)) {
            $this->error("License has been checked too many times");
            return;
        }

        // Check core app's license
        App::core()->license()->isValid();
        $this->sleepRandomTime(10);

        // Check the plugins' license
        foreach (App::plugins() as $plugin) {
            $plugin->license()->isValid();
            $this->sleepRandomTime();
        }

        $this->info("License checked");
        $limiter->hit($this->signature, 60 * 60);
    }


    private function sleepRandomTime(int $min = 1): void
    {
        if (!app()->runningUnitTests()) {
            sleep(random_int($min, 100));
        }
    }
}
