<?php

declare(strict_types = 1);

namespace JuicyCodes\Core;

use JuicyCodes\Core\Support\PluginNotRegisteredException;

class Application
{
    protected Product $core;

    protected array $plugins;

    protected string $licenseKey;

    public function init(string $version, string $codename, string $licenseKey): void
    {
        $this->setLicenseKey($licenseKey);
        $this->core = $this->createProduct("main", $version, $codename);
    }

    public function register(string $version, string $codename): void
    {
        $this->plugins[$codename] = $this->createProduct("child", $version, $codename);
    }

    public function core(): Product
    {
        return $this->core;
    }

    /**
     * @throws PluginNotRegisteredException
     */
    public function plugin(string $codename): Product
    {
        if (!array_key_exists($codename, $this->plugins())) {
            PluginNotRegisteredException::throw($codename);
        }

        return $this->plugins[$codename];
    }

    public function plugins(): array
    {
        return $this->plugins ?? [];
    }

    public function licenseKey(): string
    {
        return $this->licenseKey;
    }

    public function setLicenseKey(string $licenseKey): void
    {
        $this->licenseKey = $licenseKey;
    }

    protected function createProduct(string $type, string $version, string $codename): Product
    {
        $data = new Product();
        $data->setType($type);
        $data->setVersion($version);
        $data->setCodename($codename);

        return $data;
    }
}
