<?php

declare(strict_types = 1);

namespace JuicyCodes\Core;

use Illuminate\Support\Facades\Facade;

/**
 * @method static Product core()
 * @method static Product[] plugins()
 * @method static string licenseKey()
 * @method static Product plugin(string $codename)
 * @method static bool mockLicense(bool $mock = null)
 * @method static void setLicenseKey(string $licenseKey)
 * @method static void register(string $version, string $codename)
 * @method static void init(string $version, string $codename, string $license)
 */
class App extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return Application::class;
    }
}
