<?php

declare(strict_types=1);

namespace JuicyCodes\Core;

use JuicyCodes\Core\Support\ProductType;

final readonly class Product
{
    private LicenseChecker $licenseChecker;

    public function __construct(
        public string $codename,
        public string $version,
        public ProductType $type,
    ) {
        $this->licenseChecker = new LicenseChecker($this);
    }

    public function isLicensed(): bool
    {
        return $this->license()->isValid();
    }

    public function license(): LicenseChecker
    {
        return $this->licenseChecker;
    }
}
