<?php

declare(strict_types=1);

namespace JuicyCodes\Core\Data\License\Responses;

use Illuminate\Support\Carbon;
use Spatie\LaravelData\Attributes\WithCast;
use Spatie\LaravelData\Casts\DateTimeInterfaceCast;
use Spatie\LaravelData\Data;

abstract class LicenseResponse extends Data
{
    #[WithCast(DateTimeInterfaceCast::class, format: 'Y-m-d\TH:i:s.uT', timeZone: 'UTC')]
    public Carbon $timestamp;

    public function isValid(): bool
    {
        return $this instanceof VerifiedResponse;
    }
}
