<?php

declare(strict_types=1);

namespace JuicyCodes\Core\Data\License;

use Illuminate\Support\Carbon;
use Spatie\LaravelData\Attributes\WithCast;
use Spatie\LaravelData\Casts\DateTimeInterfaceCast;
use Spatie\LaravelData\Data;

final class LicenseLimitData extends Data
{
    public function __construct(
        #[WithCast(DateTimeInterfaceCast::class, format: 'Y-m-d', timeZone: 'UTC')]
        readonly public Carbon $updates,

        readonly public string $version,
    ) {}
}
