<?php

declare(strict_types=1);

namespace JuicyCodes\Core\Commands;

use Illuminate\Cache\RateLimiter;
use Illuminate\Console\Command;
use Illuminate\Support\Sleep;
use JuicyCodes\Core\App;

class CheckLicenseCommand extends Command
{
    protected $hidden = true;

    protected $signature = 'app:check-license';

    public function handle(RateLimiter $limiter): void
    {
        if ($limiter->tooManyAttempts($this->signature, 1)) {
            $this->error('Aborted: License check already in progress');

            return;
        }

        // Increment the rate limiter
        $limiter->increment($this->signature, 10 * 60);

        // Check core app's license
        App::app()->isLicensed();
        $this->sleepRandomTime(10);

        // Check the addons' license
        foreach (App::addons() as $addon) {
            $addon->isLicensed();
            $this->sleepRandomTime();
        }

        $this->components->info('App & Addons license check completed');
    }

    private function sleepRandomTime(int $min = 1): void
    {
        if (! app()->runningUnitTests()) {
            // @codeCoverageIgnoreStart
            Sleep::for(rand($min, 60))->seconds();
            // @codeCoverageIgnoreEnd
        }
    }
}
