<?php

declare(strict_types=1);

namespace JuicyCodes\Core;

use JuicyCodes\Core\Data\License\LicenseRequestData;
use JuicyCodes\Core\Support\AddonNotRegisteredException;
use JuicyCodes\Core\Support\ProductType;

final class Application
{
    protected LicenseRequestData $license;

    protected Product $app;

    /**
     * @var Product[]
     */
    protected array $addons = [];

    public function register(string $codename, string $version): self
    {
        $this->app = new Product($codename, $version, ProductType::App);

        return $this;
    }

    public function registerAddon(string $codename, string $version): void
    {
        $this->addons[$codename] = new Product($codename, $version, ProductType::Addon);
    }

    public function registerLicense(string $key, ?string $coreOrigin = null): self
    {
        $this->license = new LicenseRequestData($key, $coreOrigin);

        return $this;
    }

    public function license(): LicenseRequestData
    {
        return $this->license;
    }

    public function app(): Product
    {
        return $this->app;
    }

    /**
     * @return Product[]
     */
    public function addons(): array
    {
        return $this->addons;
    }

    /**
     * @throws AddonNotRegisteredException
     */
    public function addon(string $codename): Product
    {
        return $this->addons[$codename]
            ?? throw new AddonNotRegisteredException("No addon with codename `{$codename}` was registered.");
    }
}
